<?php
session_start();

include_once('../conexion.php');

function autenticar($mail, $contrasenha){
	$resultado = Conexion::autenticarUsuario($mail, $contrasenha);

	if(!$resultado || $resultado < 0) return NULL;
	
	$_SESSION['participante_id'] = $resultado;
	$_SESSION['participante_mail'] = $mail;
	$_SESSION['es_administrador'] = Conexion::EsAdmin($resultado);

	return $resultado;
}

if ($_GET['accion'] == "login"){
	$resultado = autenticar(addslashes($_GET['mail']),$_GET['contrasenha']);

	if (!is_null($resultado)) echo "ok";
	else echo "fallo";
}
elseif($_GET['accion'] == "logout")
{
	session_destroy();
}
elseif($_GET['accion'] == "crearParticipante" && $_SESSION['es_administrador'])
{
	$esAdministrador = false;
	if($_POST['administrador'] == 1)
		$esAdministrador = true;

	$resultado = Conexion::crearParticipante(addslashes($_POST['nombre']), addslashes($_POST['mail']), $_POST['contrasenha'], $esAdministrador);

	if (!is_null($resultado)) echo "ok";
	else echo "fallo";
}
elseif($_GET['accion'] == "eliminarParticipante" && $_SESSION['es_administrador'])
{
	$resultado = Conexion::eliminarParticipante(addslashes($_POST['mail']));

	if (!is_null($resultado)) echo "ok";
	else echo "fallo";
}
elseif($_GET['accion'] == "restablecerDatos" && $_SESSION['es_administrador'])
{
	$r = Conexion::ObtenerParticipantes();
	$resultArr = pg_fetch_all($r);
	foreach($resultArr as $array)
		Conexion::restablecerDatos($array["id"]);

	echo "ok";
}

?>
